function [ val ] = intspl( d,delta,c,alpha,beta )
%Integrate given spline from alpha-->beta
%   d is deg spline to be int'd. delta is its extended knot partition. c
%   is the coefficient row vector of indicated spline. alpha and beta
%   define the endpoints of integration

%Extract antiderivative spline
[deltai,ci,ni] = intsplco(d,delta,c);

%Compute definite integral
lb = findinterval(ni,deltai,beta); %find interval ends belong
la = findinterval(ni,deltai,alpha);

Fb = sval(d+1,deltai,ci,beta,lb);  %evaluate antiderivate spline
Fa = sval(d+1,deltai,ci,alpha,la);

val = Fb - Fa; %Compute definite integral

end

